#ifndef CURVE_H
#define CURVE_H

#include "field.h"
#include "poly.h"

struct curve_s;

struct point_s {
    int inf_flag;
    element_t x;
    element_t y;
    struct curve_s *curve;
};
typedef struct point_s *point_ptr;
typedef struct point_s point_t[1];

struct curve_s {
    field_ptr field;
    void (*random)(point_ptr);
    void (*add)(point_ptr, point_ptr, point_ptr);
    void (*mul)(point_ptr, mpz_ptr, point_ptr);
    void *data;
};
typedef struct curve_s *curve_ptr;
typedef struct curve_s curve_t[1];

static inline void point_init(point_ptr p, curve_ptr c)
{
    field_ptr f = c->field;
    element_init(p->x, f);
    element_init(p->y, f);
    p->curve = c;
}

static inline void point_clear(point_ptr p)
{
    //p->curve = NULL;
    element_clear(p->x);
    element_clear(p->y);
}

static inline void point_random(point_ptr p)
{
    p->curve->random(p);
}

static inline void point_add(point_ptr r, point_ptr p, point_ptr q)
{
    r->curve->add(r, p, q);
}

static inline void point_set(point_ptr p, point_ptr q)
{
    if (q->inf_flag) {
	p->inf_flag = 1;
	return;
    }
    p->inf_flag = 0;
    element_set(p->x, q->x);
    element_set(p->y, q->y);
}

static inline void point_out_str(FILE *stream, point_ptr p)
{
    if (p->inf_flag) {
	fputc('O', stream);
	return;
    }
    element_out_str(stream, p->x);
    fputc(' ', stream);
    element_out_str(stream, p->y);
}

static inline void point_mul(point_ptr r, mpz_ptr n, point_ptr p)
{
    r->curve->mul(r, n, p);
}

static inline void point_set_inf(point_ptr p)
{
    p->inf_flag = 1;
}

static inline int point_is_inf(point_ptr p)
{
    return p->inf_flag;
}

void cc_init_extend(curve_ptr cnew, curve_ptr c, field_ptr fext);
#endif //CURVE_H
