#ifndef MNT_H
#define MNT_H

#include "darray.h"
#include "curve.h"

struct cm_info_s {
    mpz_t q; //curve defined ovre F_q
    mpz_t n; //has order n (= q - t + 1) in F_q (and r^2 in F_q^6)
    mpz_t cofac; //cofac * r = n, r is prime
    mpz_t r;
    int D; //discrminant needed to find j-invariant
};

typedef struct cm_info_s *cm_info_ptr;
typedef struct cm_info_s cm_info_t[1];

void cm_info_init(cm_info_t cm);
void cm_info_clear(cm_info_t cm);

void compute_cm_curve(curve_ptr cc, field_ptr f, cm_info_ptr cm);
int find_mnt_curve(darray_t L, int D, int bitlimit);

#endif //MNT_H
