#include "pbc.h"

//alpha = 6, p = 165 bits (D = 1163)
char *p_s = "37573999432589276593381452481309299709997225870401";
char *q_s = "37573999432589276593381446351545892155895175510921";
char *j_s = "-16630626375217935193085815435940564639138489341694";

//alpha = 6, p = 82 bits (D = 163)
//char *p_s = "1014733431040759890835601";
//char *q_s = "1014733431041767230614941";
//char *j_s = "-262537412640768000";

int main()
{
    mpz_t p, z, q;
    mpz_t n;
    element_t j;
    field_t fp;
    field_t fpx;
    field_t fp6;
    curve_t c;
    curve_t c6;
    point_t P, nP, Q, nQ;
    element_t irred;
    element_t res, res0;
    mpz_t cofac;

    pbc_init();

    mpz_init(p);
    mpz_init(z);
    mpz_init(n);
    mpz_init(q);
    mpz_init(cofac);
    mpz_set_str(p, p_s, 10);
    mpz_set(z, p);
    field_init_fp(fp, z);
    element_init(j, fp);
    mpz_set_str(q, q_s, 10);
    mpz_set_str(z, j_s, 10);
    element_set_mpz(j, z);
    element_out_str(stdout, j);
    printf("\n");
    curve_init_cc_j(c, j);
    twist_curve(c);
    point_init(P, c);
    point_random(P);

    point_out_str(stdout, P);
    printf("\n");

    field_init_poly(fpx, fp);

    element_init(irred, fpx);
    do {
	poly_random_monic(irred, 6);
    } while(!poly_is_irred(irred));

    field_init_polymod(fp6, irred);

    mpz_sub_ui(cofac, fp6->order, 1);
    mpz_divexact(cofac, cofac, q);

    cc_init_extend(c6, c, fp6);

    mpz_sub(z, p, q);
    mpz_add_ui(z, z, 1);
    printf("trace: \n");
    mpz_out_str(stdout, 10, z);
    printf("\n");
    compute_trace_n(z, p, z, 6);
    printf("trace 6: \n");
    mpz_out_str(stdout, 10, z);
    printf("\n");
    mpz_sub(z, fp6->order, z);
    mpz_add_ui(z, z, 1);
    printf("order 6: \n");
    mpz_out_str(stdout, 10, z);
    printf("\n");
    mpz_divexact(z, z, q);
    mpz_divexact(z, z, q);

    point_init(nP, c);
    point_init(Q, c6);
    point_init(nQ, c6);
    point_random(Q);
    point_mul(Q, z, Q);
    printf("Q: ");
    point_out_str(stdout, Q);
    printf("\n");

    element_init(res, fp6);
    element_init(res0, fp6);

    cc_miller(res, q, P, Q);
    element_pow(res, res, cofac);
    printf("f(P, Q) = ");
    element_out_str(stdout, res);
    printf("\n");

    mpz_init(n);
    mpz_set_ui(n, 100);

    element_pow(res, res, n);
    printf("f(P, Q)^n = ");
    element_out_str(stdout, res);
    printf("\n");

    point_mul(nP, n, P);
    point_mul(nQ, n, Q);

    cc_miller(res, q, nP, Q);
    element_pow(res, res, cofac);
    printf("f(nP, Q) = ");
    element_out_str(stdout, res);
    printf("\n");

    cc_miller(res, q, P, nQ);
    element_pow(res, res, cofac);
    printf("f(P, nQ) = ");
    element_out_str(stdout, res);
    printf("\n");
    return 0;
}
