#include "pbc.h"

int main()
{
    darray_t L;
    point_t P;
    curve_t cc, cc6;
    element_t irred;
    field_t fp, fpx, fp6;
    cm_info_ptr cm;

    pbc_init();
    darray_init(L);

    find_mnt_curve(L, 9563, 500);
    //find_mnt_curve(L, 1163, 500);
    //find_mnt_curve(L, 62003, 500);

    printf("Computing Hilbert polynomial. This could take a while.\n");
    cm = L->item[0];
    compute_cm_curve(cc, fp, cm);

    printf("Got a curve:\n");
    printf("bits in q = %d\n", mpz_sizeinbase(cm->q, 2));
    printf("q = ");
    mpz_out_str(NULL, 0, cm->q);
    printf("\n");
    printf("r = ");
    mpz_out_str(NULL, 0, cm->r);
    printf("\n");
    printf("n = ");
    mpz_out_str(NULL, 0, cm->n);
    printf("\n");
    printf("cofactor = ");
    mpz_out_str(NULL, 0, cm->cofac);
    printf("\n");

    //pick a random point and see if it does indeed have the right order
    point_init(P, cc);
    point_random(P);
    printf("P = ");
    point_out_str(stdout, P);
    printf("\n");
    point_mul(P, cm->n, P);
    printf("nP = ");
    point_out_str(stdout, P);
    printf("\n");

    field_init_poly(fpx, fp);
    element_init(irred, fpx);
    do {
	poly_random_monic(irred, 6);
    } while (!poly_is_irred(irred));
    field_init_polymod(fp6, irred);

    cc_init_extend(cc6, cc, fp6);

    return 0;
}
