#ifndef FIELD_H
#define FIELD_H

#include <stdio.h>
#include <stdlib.h>
#include <gmp.h>

extern gmp_randstate_t rs;

static inline void rand_state_init()
{
    gmp_randinit_default(rs);
}

struct field_s;

struct element_s {
    struct field_s *field;
    void *data;
};
typedef struct element_s *element_ptr;
typedef struct element_s element_t[1];

struct field_s {
    void (*field_clear)(struct field_s *f);
    void (*init)(element_ptr);
    void (*clear)(element_ptr);
    void (*set_si)(element_ptr, signed long int);
    void (*set_mpz)(element_ptr, mpz_ptr);
    void (*set)(element_ptr, element_ptr);
    void (*set0)(element_ptr);
    void (*set1)(element_ptr);
    void (*out_str)(FILE *stream, element_ptr);
    void (*add)(element_ptr, element_ptr, element_ptr);
    void (*sub)(element_ptr, element_ptr, element_ptr);
    void (*mul)(element_ptr, element_ptr, element_ptr);
    void (*invert)(element_ptr, element_ptr);
    void (*neg)(element_ptr, element_ptr);
    int (*cmp)(element_ptr, element_ptr);
    void (*random)(element_ptr);
    int (*is1)(element_ptr);
    int (*is0)(element_ptr);
    int (*is_sqr)(element_ptr);
    void (*sqrt)(element_ptr, element_ptr);
    element_t nqr; //nonquadratic residue
    mpz_t order; //0 for infinite order
    void *data;
};
typedef struct field_s *field_ptr;
typedef struct field_s field_t[1];

struct fieldmap_s {
    field_ptr srcfield, dstfield;
    void (*map)(element_t dst, element_t src);
};
typedef struct fieldmap_s *fieldmap_ptr;
typedef struct fieldmap_s fieldmap_t[1];

static inline void field_clear(field_ptr f)
{
    f->field_clear(f);
}

static inline void element_init(element_ptr e, field_ptr f)
{
    e->field = f;
    f->init(e);
}

static inline void element_clear(element_ptr e)
{
    e->field->clear(e);
    e->field = NULL;
}

static inline void element_out_str(FILE *stream, element_ptr e)
{
    e->field->out_str(stream, e);
}

static inline void element_set_si(element_ptr e, signed long int i)
{
    e->field->set_si(e, i);
}

static inline void element_set_mpz(element_ptr e, mpz_ptr z)
{
    e->field->set_mpz(e, z);
}

static inline void element_set0(element_ptr e)
{
    e->field->set0(e);
}

static inline void element_set1(element_ptr e)
{
    e->field->set1(e);
}

static inline void element_set(element_ptr x, element_ptr a)
{
    x->field->set(x, a);
}

static inline void element_add(element_ptr n, element_ptr a, element_ptr b)
{
    n->field->add(n, a, b);
}

static inline void element_sub(element_ptr n, element_ptr a, element_ptr b)
{
    n->field->sub(n, a, b);
}

static inline void element_mul(element_ptr n, element_ptr a, element_ptr b)
{
    n->field->mul(n, a, b);
}

static inline void element_neg(element_ptr n, element_ptr a)
{
    n->field->neg(n, a);
}

static inline void element_invert(element_ptr n, element_ptr a)
{
    n->field->invert(n, a);
}

static inline void element_random(element_ptr n)
{
    n->field->random(n);
}

static inline int element_is1(element_ptr n)
{
    return n->field->is1(n);
}

static inline int element_is0(element_ptr n)
{
    return n->field->is0(n);
}

static inline int element_cmp(element_ptr a, element_ptr b)
{
    return a->field->cmp(a, b);
}

static inline int element_is_sqr(element_ptr a)
{
    return a->field->is_sqr(a);
}

static inline void element_sqrt(element_ptr a, element_ptr b)
{
    a->field->sqrt(a, b);
}

void field_init_fp(field_ptr f, mpz_t prime);
void element_pow(element_ptr x, element_ptr a, mpz_ptr n);
#endif //FIELD_H
