#ifndef PAIRING_H
#define PAIRING_H

#include "curve.h"

struct pairing_s {
    mpz_t r; //order of G1, G2, GT
    field_t G1, G2;
    field_ptr GT; //TODO replace with field_t?

    void (*map)(element_ptr out, element_ptr in1, element_ptr in2,
	    struct pairing_s *p);
    void *data;
};

typedef struct pairing_s pairing_t[1];
typedef struct pairing_s *pairing_ptr;

struct mnt_pairing_data_s {
    field_t Fq, Fqx, Fqk;
    curve_t Eq, Eqk;
    mpz_t tateexp;
};

typedef struct mnt_pairing_data_s mnt_pairing_data_t[1];
typedef struct mnt_pairing_data_s *mnt_pairing_data_ptr;

void pairing_init_cc_param(pairing_t pairing, cc_param_t param);

static inline void bilinear_map(element_t out, element_t in1, element_t in2,
    pairing_t pairing) {
    pairing->map(out, in1, in2, pairing);
}
#endif //PAIRING_H
