#include "pbc.h"

int main()
{
    field_t zp, rx, fp2;
    mpz_t prime;
    element_t a;
    element_t f, g;

    mpz_init(prime);
    mpz_set_si(prime, 211);
    field_init_fp(zp, prime);
    field_init_poly(rx, zp);
    element_init(f, rx);
    element_init(g, rx);
    element_init(a, zp);

    element_set_si(a, 1);
    poly_set_coeff(f, a, 2);
    poly_set_coeff(f, a, 0);

    element_out_str(stdout, f);
    if (poly_is_irred(f)) {
	printf(" is irreducible\n");
    } else {
	printf(" is not irreducible\n");
    }

    field_init_polymod(fp2, f);
    element_clear(f);
    element_clear(g);
    element_init(f, fp2);
    element_init(g, fp2);
    element_random(f);
    element_random(g);
    printf("f: ");
    element_out_str(stdout, f);
    printf(", g: ");
    element_out_str(stdout, g);
    printf("\n");
    element_mul(g, f, g);
    printf("prod: ");
    element_out_str(stdout, g);
    printf("\n");
    element_invert(f, f);
    printf("inv f: ");
    element_out_str(stdout, f);
    printf("\n");
    {
	do {
	    element_random(f);
	} while (!element_is_sqr(f));
	printf("random square f: ");
	element_out_str(stdout, f);
	printf("\n");
	element_sqrt(f, f);
	printf("sqrt f: ");
	element_out_str(stdout, f);
	printf("\n");
	element_mul(f, f, f);
	printf("f: ");
	element_out_str(stdout, f);
	printf("\n");
    }

    element_clear(f);
    element_clear(g);
    return 0;
}
