#include "pbc.h"

int main()
{
    field_t fp;
    mpz_t prime;
    element_t e, e1;
    unsigned char *data;
    int n, i;

    mpz_init(prime);
    mpz_set_ui(prime, 100000);
    mpz_nextprime(prime, prime);
    field_init_fp(fp, prime);
    element_init(e, fp);
    element_init(e1, fp);

    element_random(e);
    element_out_str(stdout, 10, e);
    printf("\n");
    n = element_length_in_bytes(e);
    printf("n = %d\n", n);
    data = (unsigned char *) malloc(n);
    element_to_bytes(data, e);
    for (i=0; i<n; i++) {
	printf(" %d", data[i]);
    }
    printf("\n");
    element_from_bytes(e1, data);
    element_out_str(stdout, 10, e1);
    printf("\n");

    return 0;
}
