//Boneh-Boyen signatures demo
#include "sig.h"

int main()
{
    cc_param_t cc_param;
    pairing_t pairing;
    bb_sys_param_t param;
    bb_public_key_t pk;
    bb_private_key_t sk;
    unsigned char *sig;

    cc_param_init(cc_param);
    printf("reading curve parameters from stdin...\n");
    cc_param_inp_str(cc_param, stdin);
    printf("initializing pairing...\n");

    pairing_init_cc_param(pairing, cc_param);
    printf("generating BLS system parameters...\n");
    bb_gen_sys_param(param, pairing);
    printf("generating key pair...\n");
    bb_gen(pk, sk, param);

    sig = (unsigned char *) malloc(param->signature_length);

    printf("signing...\n");
    bb_sign(sig, 11, "hello world", pk, sk);

    printf("verifying...\n");
    if (bb_verify(sig, 11, "hello world", pk)) {
	printf("signature verifies\n");
    } else {
	printf("signature does not verify\n");
    }
    return 0;
}
