#include "pbc.h"

int main()
{
    cc_param_t param;
    element_t g, h, x;
    element_t zg, zh;
    pairing_t pairing;
    mpz_t z;

    cc_param_init(param);
    cc_param_inp_str(param, stdin);

    pairing_init_cc_param(pairing, param);
    element_init(g, pairing->G1);
    element_init(zg, pairing->G1);
    element_init(h, pairing->G2);
    element_init(zh, pairing->G2);
    element_init(x, pairing->GT);
    element_random(g);
    printf("g = ");
    element_out_str(stdout, 0, g);
    printf("\n");
    element_random(h);
    printf("h = ");
    element_out_str(stdout, 0, h);
    printf("\n");
    bilinear_map(x, g, h, pairing);
    printf("f(g, h) = ");
    element_out_str(stdout, 0, x);
    printf("\n");

    mpz_init(z);
    pbc_mpz_random(z, pairing->r);
    printf("z = ");
    mpz_out_str(stdout, 0, z);
    printf("\n");

    element_pow(x, x, z);
    printf("f(g, h)^z = ");
    element_out_str(stdout, 0, x);
    printf("\n");

    element_pow(zg, g, z);
    printf("g^z = ");
    element_out_str(stdout, 0, zg);
    printf("\n");
    bilinear_map(x, zg, h, pairing);
    printf("f(g^z, h) = ");
    element_out_str(stdout, 0, x);
    printf("\n");

    element_pow(zh, h, z);
    printf("h^z = ");
    element_out_str(stdout, 0, zh);
    printf("\n");
    bilinear_map(x, g, zh, pairing);
    printf("f(g, h^z) = ");
    element_out_str(stdout, 0, x);
    printf("\n");

    return 0;
}
