#ifndef PAIRING_H
#define PAIRING_H

#include "curve.h"

//for shoehorning the group of points on a curve into the `field' data type
struct curve_group_data_s {
    curve_ptr curve;
    mpz_t cofac;
};
typedef struct curve_group_data_s curve_group_data_t[1];
typedef struct curve_group_data_s *curve_group_data_ptr;

struct pairing_s {
    mpz_t r; //order of G1, G2, GT
    field_t Zr; //the field Z_r
    field_t G1, G2;
    field_ptr GT; //TODO replace with field_t?

    void (*phi)(element_ptr out, element_ptr in, struct pairing_s *pairing); //isomorphism G2 --> G1
    void (*map)(element_ptr out, element_ptr in1, element_ptr in2,
	    struct pairing_s *p);
    //is_almost coddh returns 1 given (g, g^x, h, h^x) or (g, g^x, h, h^-x)
    //0 otherwise
    //order is important: a, b are from G1, c, d are from G2
    int (*is_almost_coddh)(element_ptr a, element_ptr b,
	    element_ptr c, element_ptr d,
	    struct pairing_s *p);
    void *data;
};

typedef struct pairing_s pairing_t[1];
typedef struct pairing_s *pairing_ptr;

struct mnt_pairing_data_s {
    field_t Fq, Fqx, Fqk;
    curve_t Eq, Eqk;
    mpz_t tateexp;
    int k;
};

typedef struct mnt_pairing_data_s mnt_pairing_data_t[1];
typedef struct mnt_pairing_data_s *mnt_pairing_data_ptr;

void pairing_init_cc_param(pairing_t pairing, cc_param_t param);

static inline void bilinear_map(element_t out, element_t in1, element_t in2,
    pairing_t pairing) {
    pairing->map(out, in1, in2, pairing);
}

static inline int is_almost_coddh(element_t a, element_t b,
	element_t c, element_t d, pairing_t pairing) {
    return pairing->is_almost_coddh(a, b, c, d, pairing);
}
#endif //PAIRING_H
