#include <string.h>
#include <stdlib.h>
#include "parse.h"

void token_init(token_t tok)
{
    tok->type = token_none;
    tok->s = NULL;
}

void token_clear(token_t tok)
{
    free(tok->s);
}

void token_get(token_t tok, FILE *stream)
{
    char *buf;
    int n = 32;
    int i;
    int c;

skipwhitespace:
    for (;;) {
	c = fgetc(stream);
	if (c == EOF) {
	    tok->type = token_eof;
	    return;
	}
	if (!strchr(" \t\r\n", c)) break;
    }

    if (c == '#') {
	for(;;) {
	    c = fgetc(stream);
	    if (c == EOF) {
		tok->type = token_eof;
		return;
	    }
	    if (c == '\n') break;
	}
	goto skipwhitespace;
    }

    if (c == '<') {
	c = fgetc(stream);
	if (c == '/') {
	    tok->type = token_langleslash;
	    return;
	}
	ungetc(c, stream);
	tok->type = token_langle;
	return;
    } else if (c == '>') {
	tok->type = token_rangle;
	return;
    } else {
	tok->type = token_word;
	free(tok->s);
	buf = (char *) malloc(n);
	i = 0;
	for (;;) {
	    buf[i] = c;
	    i++;
	    if (i == n) {
		n += 32;
		buf = (char *) realloc(buf, n);
	    }
	    c = fgetc(stream);
	    if (c == EOF || strchr(" \t\r\n</>", c)) break;
	}
	buf[i] = 0;
	ungetc(c, stream);
	tok->s = buf;
    }
}
