#include "pbc.h"

void solinas_param_init(solinas_param_t sp)
{
    mpz_init(sp->r);
    mpz_init(sp->q);
    mpz_init(sp->h);
}

void solinas_param_clear(solinas_param_t sp)
{
    mpz_clear(sp->r);
    mpz_clear(sp->q);
    mpz_clear(sp->h);
}

void solinas_param_gen(solinas_param_t sp, int rbits, int qbits)
{
    int found = 0;

    mpz_ptr q = sp->q;
    mpz_ptr r = sp->r;
    mpz_ptr h = sp->h;

    sp->exp2 = rbits;

    do {
	int i;
	mpz_set_ui(r, 0);
	mpz_setbit(r, sp->exp2);

	//use q as a temp variable
	mpz_set_ui(q, 0);
	do {
	    sp->exp1 = rand() % 160;
	} while (!sp->exp1);
	mpz_setbit(q, sp->exp1);
	if (rand() % 2) {
	    sp->sign1 = 1;
	    mpz_add(r, r, q);
	} else {
	    sp->sign1 = -1;
	    mpz_sub(r, r, q);
	}
	if (rand() % 2) {
	    sp->sign0 = 1;
	    mpz_add_ui(r, r, 1);
	} else {
	    sp->sign0 = -1;
	    mpz_sub_ui(r, r, 1);
	}
	if (!mpz_probab_prime_p(r, 10)) continue;
	for (i=0; i<10; i++) {
	    //use q as a temp variable
	    mpz_set_ui(q, 0);
	    mpz_setbit(q, qbits - sp->exp2 - 4);
	    pbc_mpz_random(h, q);
	    mpz_mul_ui(h, h, 12);
	    //finally q takes the value it should
	    mpz_mul(q, h, r);
	    mpz_sub_ui(q, q, 1);
	    if (mpz_probab_prime_p(q, 10)) {
		found = 1;
		break;
	    }
	}
    } while (!found);
}

void solinas_param_out_str(FILE *stream, solinas_param_ptr p)
{
    void out(char *s, mpz_t z)
    {
	fprintf(stream, "%s ", s);
	mpz_out_str(stream, 0, z);
	fprintf(stream, "\n");
    }

    out("q", p->q);
    out("r", p->r);
    printf("exp2 %d\n", p->exp2);
    printf("exp1 %d\n", p->exp1);
    printf("sign1 %d\n", p->sign1);
    printf("sign0 %d\n", p->sign0);
}
