#ifndef SOLINAS_H
#define SOLINAS_H

#include "fieldi.h"

struct solinas_param_s {
    int exp2;
    int exp1;
    int sign1;
    int sign0;
    mpz_t r; // r = 2^exp2 + sign1 * 2^exp1 + sign0 * 1
    mpz_t q; // we work in E(F_q) (and E(F_q^2))
    mpz_t h; // r * h = q + 1
};
typedef struct solinas_param_s solinas_param_t[1];
typedef struct solinas_param_s *solinas_param_ptr;

void solinas_param_init(solinas_param_t sp);
void solinas_param_clear(solinas_param_t sp);
void solinas_param_gen(solinas_param_t sp, int rbits, int qbits);
void solinas_param_out_str(FILE *stream, solinas_param_ptr p);

#endif //SOLINAS_H
