#include "pbc.h"
#include "get_time.h"

int main()
{
    solinas_param_t sp;
    pairing_t pairing;
    element_t x, y, z, r;
    int i, n;
    double t0, t1, ttotal;

    solinas_param_init(sp);
    solinas_param_gen(sp, 160, 512);

    pairing_init_solinas_param(pairing, sp);
    element_init(x, pairing->G1);
    element_init(y, pairing->G2);
    element_init(z, pairing->G1);
    element_init(r, pairing->GT);

    n = 10;
    ttotal = 0.0;
    for (i=0; i<n; i++) {
	element_random(x);
	element_random(y);
	printf("x = ");
	element_out_str(stdout, 0, x);
	printf("\n");
	printf("y = ");
	element_out_str(stdout, 0, y);
	printf("\n");
	t0 = get_time();
	bilinear_map(r, x, y, pairing);
	t1 = get_time();
	ttotal += t1 - t0;
	printf("e(x,y) = ");
	element_out_str(stdout, 0, r);
	printf("\n");
    }
    printf("average pairing time = %f\n", ttotal / n);
    element_clear(x);
    element_clear(y);
    element_clear(z);
    element_clear(r);

    return 0;
}
