#include <stdlib.h>
#include <gmp.h>

struct curve_s;

struct point_s {
    mpz_t x;
    mpz_t y;
    struct curve_s *curve;
};
typedef struct point_s *point_ptr;
typedef struct point_s point_t[1];

struct curve_s {
    mpz_t p;
    void (*rand)(point_ptr);
};
typedef struct curve_s *curve_ptr;
typedef struct curve_s curve_t[1];

void point_init(point_ptr p, curve_ptr curve)
{
    mpz_init(p->x);
    mpz_init(p->y);
    p->curve = curve;
}

void point_clear(point_ptr p)
{
    mpz_clear(p->x);
    mpz_clear(p->y);
    p->curve = NULL;
}

void point_rand(point_ptr p)
{
    p->curve->rand(p);
}

static void singrand(point_ptr p)
{
}

void curve_init(curve_ptr c)
{
    mpz_set_ui(c->p, 101);
    c->rand = singrand;
}

int main()
{
    curve_t c;
    point_t p;

    curve_init(c);
    point_init(p, c);

    return 0;
}
