#ifndef PAIRING_H
#define PAIRING_H

#include "curve.h"
#include "solinas.h"

struct pairing_s {
    mpz_t r; //order of G1, G2, GT
    field_t Zr; //the field Z_r
    field_ptr G1, G2, GT;

    void (*phi)(element_ptr out, element_ptr in, struct pairing_s *pairing); //isomorphism G2 --> G1
    void (*map)(element_ptr out, element_ptr in1, element_ptr in2,
	    struct pairing_s *p);
    //is_almost coddh returns 1 given (g, g^x, h, h^x) or (g, g^x, h, h^-x)
    //0 otherwise
    //order is important: a, b are from G1, c, d are from G2
    int (*is_almost_coddh)(element_ptr a, element_ptr b,
	    element_ptr c, element_ptr d,
	    struct pairing_s *p);
    void *data;
};

typedef struct pairing_s pairing_t[1];
typedef struct pairing_s *pairing_ptr;

struct mnt_pairing_data_s {
    field_t Fq, Fqx, Fqk;
    curve_t Eq, Eqk;
    mpz_t tateexp;
    int k;
    fieldmap mapbase;
    element_ptr *xpowq;
};
typedef struct mnt_pairing_data_s mnt_pairing_data_t[1];
typedef struct mnt_pairing_data_s *mnt_pairing_data_ptr;

struct even_mnt_pairing_data_s {
    field_t Fq, Fqx, Fqd, Fqk;
    curve_t Eq, Etwist;
    element_t nqrinv, nqrinv2;
    mpz_t tateexp;
    int k;
    fieldmap mapbase;
    element_ptr *xpowq;
};
typedef struct even_mnt_pairing_data_s even_mnt_pairing_data_t[1];
typedef struct even_mnt_pairing_data_s *even_mnt_pairing_data_ptr;

struct solinas_pairing_data_s {
    field_t Fq, Fq2;
    curve_t Eq, Eq2;
    mpz_t h;
    int exp2, exp1;
    int sign1;
};
typedef struct solinas_pairing_data_s solinas_pairing_data_t[1];
typedef struct solinas_pairing_data_s *solinas_pairing_data_ptr;

void pairing_init_cc_param(pairing_t pairing, cc_param_t param);

static inline void bilinear_map(element_t out, element_t in1, element_t in2,
    pairing_t pairing) {
    pairing->map(out, in1, in2, pairing);
}

static inline int is_almost_coddh(element_t a, element_t b,
	element_t c, element_t d, pairing_t pairing) {
    return pairing->is_almost_coddh(a, b, c, d, pairing);
}

static inline void cc_param_init_inp_str(cc_param_ptr p, FILE *stream)
{
    cc_param_init(p);
    cc_param_init_inp_str(p, stream);
}
#endif //PAIRING_H
