#include "pbc.h"

int main()
{
    solinas_param_t sp;
    element_t a, b;
    field_t Fq, Fq2;
    curve_t Eq, Eq2;
    point_t P, Q;

    solinas_param_init(sp);
    solinas_param_gen(sp, 160, 512);

    field_init_fp(Fq, sp->q);
    field_init_fi(Fq2, Fq);
    element_init(a, Fq);
    element_init(b, Fq);
    element_set1(a);
    element_set0(b);
    curve_init_cc_ab(Eq, a, b);
    element_clear(a);
    element_clear(b);
    element_init(a, Fq2);
    element_init(b, Fq2);
    element_set1(a);
    element_set0(b);
    curve_init_cc_ab(Eq2, a, b);
    point_init(P, Eq2);
    point_init(Q, Eq2);
    point_random(P);
    point_random(Q);
    point_add(P, P, Q);
    point_mul(P, sp->h, P);
    printf("P = ");
    point_out_str(stdout, 0, P);
    printf("\n");

    point_mul(P, sp->r, P);
    printf("rP = ");
    point_out_str(stdout, 0, P);
    printf("\n");

    //now test a pairing based on these params
    {
	pairing_t pairing;
	element_t x, y, z, r;

	pairing_init_solinas_param(pairing, sp);
	//pairing->G1 = pairing->G2 in this case
	element_init(x, pairing->G1);
	element_init(y, pairing->G1);
	element_init(z, pairing->G1);
	element_init(r, pairing->GT);

	element_random(x);
	element_random(y);
	printf("x = ");
	element_out_str(stdout, 0, x);
	printf("\n");
	printf("y = ");
	element_out_str(stdout, 0, y);
	printf("\n");

	element_mul(z, y, y);
	bilinear_map(r, x, z, pairing);
	printf("e(x,y^2) = ");
	element_out_str(stdout, 0, r);
	printf("\n");

	element_mul(z, x, x);
	bilinear_map(r, z, y, pairing);
	printf("e(x^2,y) = ");
	element_out_str(stdout, 0, r);
	printf("\n");

	bilinear_map(r, x, y, pairing);
	element_mul(r, r, r);
	printf("e(x,y)^2 = ");
	element_out_str(stdout, 0, r);
	printf("\n");

	element_clear(x);
	element_clear(y);
	element_clear(z);
	element_clear(r);
    }
    return 0;
}
