#include "pbc.h"

int main()
{
    field_t fp;
    mpz_t prime;
    element_t x, y, z;
    int i, n;

    mpz_init(prime);
    mpz_set_ui(prime, 100000);
    mpz_nextprime(prime, prime);
    field_init_fp(fp, prime);

    element_init(x, fp);
    element_init(y, fp);
    element_init(z, fp);

    mem_report();
    n = 100;
    for (i=0; i<n; i++) {
	element_random(x);
	element_random(y);
	element_mul(z, x, y);
	element_add(z, x, y);
	element_sub(z, x, y);
    }
    mem_report();
    return 0;
}
