#include "pbc.h"
#include "get_time.h"

int main(void)
{
    cc_param_t param;
    pairing_t pairing;
    element_t x, y, r;
    int i, n;
    double t0, t1, ttotal;

    cc_param_init(param);
    cc_param_inp_str(param, stdin);

    pairing_init_cc_param(pairing, param);
    element_init(x, pairing->G1);
    element_init(y, pairing->G2);
    element_init(r, pairing->GT);

    n = 5;
    ttotal = 0.0;
    for (i=0; i<n; i++) {
	element_random(x);
	element_random(y);
	printf("x = ");
	element_out_str(stdout, 0, x);
	printf("\n");
	printf("y = ");
	element_out_str(stdout, 0, y);
	printf("\n");
	t0 = get_time();
	bilinear_map(r, x, y, pairing);
	t1 = get_time();
	ttotal += t1 - t0;
	printf("e(x,y) = ");
	element_out_str(stdout, 0, r);
	printf("\n");
    }
    printf("average pairing time = %f\n", ttotal / n);
    element_clear(x);
    element_clear(y);
    element_clear(r);

    return 0;
}
