//Boneh-Lynn-Shacham short signatures demo
//This one uses the signature library and is more realistic
#include "sig.h"

int main(void)
{
    cc_param_t cc_param;
    pairing_t pairing;
    bls_sys_param_t param;
    bls_public_key_t pk;
    bls_private_key_t sk;
    unsigned char *sig;

    cc_param_init(cc_param);
    printf("reading curve parameters from stdin...\n");
    cc_param_inp_str(cc_param, stdin);
    printf("initializing pairing...\n");

    pairing_init_cc_param(pairing, cc_param);
    printf("generating BLS system parameters...\n");
    bls_gen_sys_param(param, pairing);
    printf("generating key pair...\n");
    bls_gen(pk, sk, param);

    sig = (unsigned char *) malloc(param->signature_length);

    printf("signing...\n");
    bls_sign(sig, 11, "hello world", sk);

    printf("verifying...\n");
    if (bls_verify(sig, 11, "hello world", pk)) {
	printf("signature verifies\n");
    } else {
	printf("signature does not verify\n");
    }
    return 0;
}
