#include "pbc.h"

int main(void)
{
    darray_t L;
    cc_param_t param;
    cm_info_ptr cm;

    darray_init(L);

    //find_mnt6_curve(L, 62003, 500);
    find_mnt6_curve(L, 9563, 500);
    //find_mnt6_curve(L, 1163, 500);

    cm = L->item[0];
    cc_param_init(param);

    fprintf(stderr, "Computing Hilbert polynomial...\n");
    compute_cm_curve(param, cm);
    fprintf(stderr, "done\n");
    fprintf(stderr, "bits in q = %zu\n", mpz_sizeinbase(cm->q, 2));
    cc_param_out_str(stdout, param);

    return 0;
}
