#include "pbc.h"

int main(int argc, char **argv)
{
    darray_t L;
    int D = 7;
    cm_info_ptr cm;
    int i=0;
    darray_init(L);

    if (argc > 1) {
	D = atoi(argv[1]);
	if (D < 7 || (D % 4) != 3) {
	    fprintf(stderr, "D must be 3 mod 4 and at least 7\n");
	    exit(1);
	}
    }

    void try(void) {
	if (find_mnt6_curve(L, D, 500)) {
	    for (; i<L->count; i++) {
		printf("Curve %d-", D);
		cm = L->item[i];
		mpz_out_str(stdout, 0, cm->q);
		printf(":\n%d-bit q\n", mpz_sizeinbase(cm->q, 2));
		printf("%d-bit r\n", mpz_sizeinbase(cm->r, 2));
		fflush(stdout);
	    }
	}
    }

    while (D < 100000000) {
	try();
	D++;
	try();
	D+=3;
    }

    return 0;
}
