#include "pbc.h"
#include "c_param.h"

int main(void)
{
    darray_t L;
    c_param_t param;
    cm_info_ptr cm;

    darray_init(L);

    //D = 62003 gives a 159-bit curve
    //find_mnt6_curve(L, 62003, 500);
    //D = 9563 gives a 201-bit curve
    find_mnt6_curve(L, 9563, 500);
    //find_mnt6_curve(L, 1163, 500);

    cm = L->item[0];
    c_param_init(param);

    fprintf(stderr, "Computing Hilbert polynomial...\n");
    c_param_from_cm(param, cm);
    fprintf(stderr, "done\n");
    fprintf(stderr, "bits in q = %zu\n", mpz_sizeinbase(cm->q, 2));
    c_param_out_str(stdout, param);
    return 0;
}
